﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zaświadczenie o zarobkach szczegółowe</title>
		<script runat="server">
		
	//Elementy wg nazwy
	//Tutaj wpisujemy nazwy elementów które mają zostać uwzględnione w zesatwieniu nawet jeżeli
	//nie spełniają innych kryteriów.
	//Każda nazwa musi być wpisana w '"' i oddzielona ',' od następnej.
	static readonly string[] nazwyDodatków = new string[] {};

    //A tutaj tak samo, ale elementy, które mają być zawsze pominięte    
    //static readonly string[] pomińDodatki = new string[] { };
		    	
	//Uwzględniemy wszystkie elementy opodatkowane ewentualnie poza zaliczkami
	//Oraz elementy nieopodatkowane wg podanych założeń	
	Hashtable wyjatki = null;
	bool Wchodzi(WypElement e) {
		if (wyjatki==null) {
			wyjatki = new Hashtable();
			foreach (string nazwa in nazwyDodatków)
				wyjatki[nazwa.ToLower()] = true;
            if (srpars.Wykluczone != null)
                foreach (DefinicjaElementu de in srpars.Wykluczone)
                    wyjatki[de.Nazwa.ToLower()] = false;
        }

        object obj = wyjatki[e.Definicja.Nazwa.ToLower()];
        if (obj != null)
            return (bool)obj;

        if (!e.Definicja.DoWyplaty && !srpars.Niewplywajacy)
            return false;
		
		if (e.Definicja.Info.Opodatkowany)
			switch (e.RodzajZrodla) {
				case RodzajŹródłaWypłaty.Zaliczka:
				case RodzajŹródłaWypłaty.SpłataZaliczki:
					return srpars.ZaliczkiISplatyOpodatkowane;
				default:
					return true;
			}
			
		switch (e.RodzajZrodla) {
			case RodzajŹródłaWypłaty.Zaliczka:
			case RodzajŹródłaWypłaty.SpłataZaliczki:
                return srpars.ZaliczkiISplatyNieopodatkowane;

			case RodzajŹródłaWypłaty.Pożyczka:
			case RodzajŹródłaWypłaty.PożyczkaSpłata:
				return srpars.PozyczkiISplaty;
				
			default:
				return !e.Definicja.Info.Potrącenie ? srpars.DodatkiNieopodatkowane : srpars.PotraceniaNieopodatkowane;
		}		
	}
	
	//Wchodzi jako zasiłek rodzonny lub pielęgnacyjny?
	bool Zasiłek(WypElement e) {
		switch (e.Definicja.Deklaracje.PozycjaRCA) {
			case PozycjaRCA.ZasiłekRodzinny:
			case PozycjaRCA.DodatekRodzinny:
			case PozycjaRCA.ZasiłekPielęgnacyjny:
			case PozycjaRCA.DodDoZasRodzinnego:
				return true;
		}
		return false;
	}
	
    public class PrnParams: Soneta.Business.OkresContext {
    
        public PrnParams(Context context): base(context) {
            wgDatyWypłaty = true;
            YearMonth to = new YearMonth(Aktualny);
            to -= 1;
            YearMonth from = to - 2;
            base.Okres = new FromTo(from.FirstDay, to.LastDay);
        }
    
        [Browsable(false)]
        public override Date Aktualny {
            get { return base.Aktualny; }
            set { base.Aktualny = value; }
        }
    
    
        [Priority(1)]
        public override FromTo Okres {
            get { return base.Okres; }
            set { base.Okres = value; }
        }
    
        bool wgDatyWypłaty;
        [Priority(2)]
        public bool WgDatyWypłaty {
            get { return wgDatyWypłaty; }
            set {
                wgDatyWypłaty = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool etat = true;
        [Priority(3)]
        public bool WypłatyZaEtat {
            get { return etat; }
            set {
                etat = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool umowa = false;
        [Priority(4)]
        public bool Umowy {
            get { return umowa; }
            set {
                umowa = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool inne = false;
        public bool InneWypłaty {
            get { return inne; }
            set {
                inne = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    PrnParams pars;
    [Soneta.Business.Context(Required=true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }

    public enum InfoKwota {
        Netto,
        Brutto,
        [Caption("Netto i brutto")]
        NettoBrutto
    }
    
    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //W raporcie uwzględniaj następujące elementy nieopodatkowane:
        //Pożyczki i spłaty pożyczek
        //static readonly bool pozyczkiISplaty = false;
        bool pozyczkiISplaty = false;
        [Priority(1)]
        [Caption("Pożyczki i spłaty")]
        public bool PozyczkiISplaty {
            get { return pozyczkiISplaty; }
            set {
                pozyczkiISplaty = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Zaliczki opodatkowane i ich spłaty
        //static readonly bool zaliczkiISplatyOpodatkowane = false;
        bool zaliczkiISplatyOpodatkowane = false;
        [Priority(2)]
        [Caption("Zalicz. i spłaty opodatk.")]
        public bool ZaliczkiISplatyOpodatkowane {
            get { return zaliczkiISplatyOpodatkowane; }
            set {
                zaliczkiISplatyOpodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Zaliczki nieopodatkowane i ich spłaty
        //static readonly bool zaliczkiISplatyNieopodatkowane = false;
        bool zaliczkiISplatyNieopodatkowane = false;
        [Priority(3)]
        [Caption("Zalicz. i spł. nieopodatk.")]
        public bool ZaliczkiISplatyNieopodatkowane {
            get { return zaliczkiISplatyNieopodatkowane; }
            set {
                zaliczkiISplatyNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Dodatki nieopodatkowane
        //static readonly bool dodatkiNieopodatkowane = true;
        bool dodatkiNieopodatkowane = true;
        [Priority(4)]
        [Caption("Dodatki nieopodatk.")]
        public bool DodatkiNieopodatkowane {
            get { return dodatkiNieopodatkowane; }
            set {
                dodatkiNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Potrącenie nieopodatkowane
        //static readonly bool potraceniaNieopodatkowane = false;
        bool potraceniaNieopodatkowane = false;
        [Priority(5)]
        [Caption("Potrącenia nieopodatk.")]
        public bool PotraceniaNieopodatkowane {
            get { return potraceniaNieopodatkowane; }
            set {
                potraceniaNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        bool pelneStanowisko = false;
        [Priority(6)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool niewplywajacy = false;
        [Priority(7)]
        [Caption("Uwzględnij niepieniężne")]
        public bool Niewplywajacy {
            get { return niewplywajacy; }
            set {
                niewplywajacy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        InfoKwota info = InfoKwota.Brutto;
        [Priority(8)]
        [Caption("Informacja o kwocie")]
        public InfoKwota Info {
            get { return info; }
            set {
                info = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        DefinicjaElementu[] wykluczone;
        [Priority(9)]
        [Caption("Wyklucz elementy")]
        public DefinicjaElementu[] Wykluczone {
            get { return wykluczone; }
            set {
                wykluczone = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }

    private class NettoBrutto {
        private decimal netto;
        public decimal Netto {
            get { return netto; }
        }
        
        private decimal brutto;
        public decimal Brutto {
            get { return brutto; }
        }

        public void AddNetto(decimal netto) {
            this.netto += netto;
        }

        public void AddBrutto(decimal brutto) {
            this.brutto += brutto;
        }
    }
    
    Hashtable wynagrodzenia = new Hashtable();
    decimal brutto, zalPIT, netto, nieopodatkowanePlus, nieopodatkowaneMinus, eu, ef, ru, rf, cu, cf, wu, wf, z, f, k, u, p, zas;

            void OnContextLoad(Object sender, EventArgs args) {
                Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];
                PracHistoria historia = pracownik[pars.Aktualny];
                report = ReportHeader1;
                ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(historia);
                ReportHeader1["TYP"] = pars.WgDatyWypłaty ? "wg daty wypłaty" : "wg okresu";

                if (historia.Plec != 0) {
                    Pan.EditValue = "Pan:";
                    Otrzymał.EditValue = "otrzymał";
                    Zamieszkały.EditValue = "Zamieszkały:";
                }
                else {
                    Pan.EditValue = "Pani:";
                    Otrzymał.EditValue = "otrzymała";
                    Zamieszkały.EditValue = "Zamieszkała:";
                }

                sectDodatkiNetto.Visible = srpars.PozyczkiISplaty | srpars.ZaliczkiISplatyNieopodatkowane | srpars.DodatkiNieopodatkowane;
                sectPotrąceniaNetto.Visible = srpars.PozyczkiISplaty | srpars.ZaliczkiISplatyNieopodatkowane | srpars.PotraceniaNieopodatkowane;                
                    
                Pracownik.EditValue = pracownik.ImięNazwisko;
                Adres.EditValue = historia.Adres.Linia1 + ", " + historia.Adres.Linia2;
                Pesel.EditValue = historia.PESEL;
                OkresOd.EditValue = pars.Okres.From;
                OkresDo.EditValue = pars.Okres.To;

                if (pars.WypłatyZaEtat) {
                    FromTo okres = historia.Etat.OkresZatrudnienia;
                    string sto = okres.To == Date.MaxValue ? ". . . . . . . . . . . . . . ." : "<b>" + okres.To + "</b>";
                    string płeć = historia.Plec != 0 ? "zatrudniony" : "zatrudniona";
                    Info.EditValue = "jest " + płeć + " w naszym zakładzie pracy <b>" +
                        CaptionAttribute.EnumToString(historia.Etat.TypUmowy).ToLower() + "</b><br>" +
                        "od dnia: <b>" + okres.From + "</b> " +
                        (historia.Etat.TypUmowy != TypUmowyOPrace.NaCzasNieokreślony ? "do dnia: " + sto : "") + "<br>" +
                        "na stanowisku: <b>" + GetStanowisko(historia) + "</b>.";
                }
                else
                    Info.EditValue = "wykonuje pracę w naszym zakładzie na podstawie umowy zlecenia/o dzieło.";

                SubTable elementy;
                PlaceModule płace = PlaceModule.GetInstance(pracownik);

                foreach (Pracownik pp in pracownik.PracownicyPowiązani) {
                    if (pars.WgDatyWypłaty)
                        elementy = płace.WypElementy.WgDaty[pp];
                    else
                        elementy = płace.WypElementy.WgPracownik[pp];
                    elementy = new SubTable(elementy, pars.Okres);

                    foreach (WypElement e in elementy) {
                        try {
                            if (Zasiłek(e))
                                zas += e.Wartosc;
                            else if (Wchodzi(e)) {
                                bool ok;
                                switch (e.Wyplata.Typ) {
                                    case TypWyplaty.Etat:
                                        ok = pars.WypłatyZaEtat; break;
                                    case TypWyplaty.Umowa:
                                        ok = pars.Umowy; break;
                                    default:
                                        ok = pars.InneWypłaty; break;
                                }

                                if (ok) {
                                    YearMonth miesiąc = new YearMonth(pars.WgDatyWypłaty ? e.Data : e.Okres.To);
                                    NettoBrutto value = (NettoBrutto)wynagrodzenia[miesiąc];
                                    if (value == null)
                                        wynagrodzenia.Add(miesiąc, value = new NettoBrutto());
                                    if (e.Definicja.Info.Opodatkowany) {
                                        brutto += e.Wartosc;
                                        value.AddBrutto(e.Wartosc);
                                    }
                                    else if (e.Definicja.Info.Potrącenie)
                                        nieopodatkowaneMinus -= e.Netto;
                                    else
                                        nieopodatkowanePlus += e.Netto;
                                    if (!e.Definicja.Info.Potrącenie) {
                                        netto += e.Netto;
                                        value.AddNetto(e.Netto);
                                    }
                                
                                    eu += e.Podatki.Emerytalna.Prac;
                                    ef += e.Podatki.Emerytalna.Firma;
                                    ru += e.Podatki.Rentowa.Prac;
                                    rf += e.Podatki.Rentowa.Firma;
                                    cu += e.Podatki.Chorobowa.Prac;
                                    cf += e.Podatki.Chorobowa.Firma;
                                    wu += e.Podatki.Wypadkowa.Prac;
                                    wf += e.Podatki.Wypadkowa.Firma;
                                    z += e.Podatki.Zdrowotna.Prac;
                                    f += e.Podatki.FP.Skladka + e.Podatki.FGSP.Skladka + e.Podatki.FEP.Skladka;
                                    k += e.Podatki.KosztyPIT;
                                    u += e.Podatki.Ulga;
                                    p += e.Podatki.ZalFIS;
                                    zalPIT += e.Podatki.ZalFIS;
                                }
                            }
                        }
                        catch { Msg(); }
                    }
                }

                ArrayList keys = new ArrayList(wynagrodzenia.Keys);
                keys.Sort();
                string txt;
                string body, body1 = "", body2 = "";
                //decimal razem = 0;
                int miesiące = 0;
                foreach (YearMonth ym in keys) {
                    NettoBrutto w = (NettoBrutto)wynagrodzenia[ym];
                    if (w.Netto != 0m || w.Brutto != 0m) {
                        txt = (srpars.Info == InfoKwota.Brutto || srpars.Info == InfoKwota.NettoBrutto) ? w.Brutto.ToString("n") + " brutto" : "";
                        txt += (srpars.Info == InfoKwota.Netto || srpars.Info == InfoKwota.NettoBrutto) ? (txt != "" ? " / " : "") + w.Netto.ToString("n") + " netto" : "";
                        body = "<TR><TD width=\"40%\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- " + ym + ":</TD><TD align=\"right\"><strong>" + txt + "</strong></TD></TR>";
                        if (miesiące < 40)
                            body1 += body;
                        else
                            body2 += body;
                        //razem += w;
                        miesiące++;
                    }
                }

                dlBrutto.EditValue = brutto;
                SłownieBrutto.EditValue = Currency.SłownieWaluta(brutto);
                decimal bruttoAvr = 0;
                if (miesiące != 0)
                    bruttoAvr = Soneta.Tools.Math.RoundCy(brutto / miesiące);
                dlAvrBrutto.EditValue = bruttoAvr;
                SłownieAvrBrutto.EditValue = Currency.SłownieWaluta(bruttoAvr);

                dlNetto.EditValue = netto;
                SłownieNetto.EditValue = Currency.SłownieWaluta(netto);
                decimal nettoAvr = 0;
                if (miesiące != 0)
                    nettoAvr = Soneta.Tools.Math.RoundCy(netto / miesiące);
                dlAvrNetto.EditValue = nettoAvr;
                SłownieAvrNetto.EditValue = Currency.SłownieWaluta(nettoAvr);

                scBrutto.Visible = (srpars.Info == InfoKwota.Brutto || srpars.Info == InfoKwota.NettoBrutto);
                scNetto.Visible = (srpars.Info == InfoKwota.Netto || srpars.Info == InfoKwota.NettoBrutto);
                
                Miesiące1.EditValue = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"70%\" style=\"font-size: 1.8ex; font-family: Tahoma;\">" + body1 + "</TABLE>";
                if (!string.IsNullOrEmpty(body2))
                    Miesiące2.EditValue = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"70%\" style=\"font-size: 1.8ex; font-family: Tahoma;\">" + body2 + "</TABLE>";
                else
                    PageBreak5.Visible = false;
                
                EmerPrac.EditValue = eu;
                EmerFirma.EditValue = ef;
                RentPrac.EditValue = ru;
                RentFirma.EditValue = rf;
                ChorPrac.EditValue = cu;
                ChorFirma.EditValue = cf;
                WypadPrac.EditValue = wu;
                WypadFirma.EditValue = wf;

                EmerRazem.EditValue = eu + ef;
                RentRazem.EditValue = ru + rf;
                ChorRazem.EditValue = cu + cf;
                WypadRazem.EditValue = wu + wf;

                PracRazem.EditValue = eu + ru + cu + wu;
                FirmaRazem.EditValue = ef + rf + cf + wf;

                Razem.EditValue = eu + ru + cu + wu + ef + rf + cf + wf;

                Zdrow.EditValue = z;
                Fundusze.EditValue = f;
                Koszty.EditValue = k;
                Ulga.EditValue = u;
                ZalPIT.EditValue = zalPIT;
                BezZus.EditValue = brutto - eu - ru - cu - wu + nieopodatkowanePlus;
                Netto.EditValue = netto; //+ nieopodatkowanePlus;

                if (sectDodatkiNetto.Visible && nieopodatkowanePlus == 0)
                    sectDodatkiNetto.Visible = false;
                else
                    NettoPlus.EditValue = nieopodatkowanePlus;

                if (sectPotrąceniaNetto.Visible && nieopodatkowaneMinus == 0)
                    sectPotrąceniaNetto.Visible = false;
                else {
                    NettoMinus.EditValue = nieopodatkowaneMinus;
                    NettoPoNettoMinus.EditValue = netto - nieopodatkowaneMinus;
                }                    
                
                Zasiłki.EditValue = zas;
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }

            string GetMiejscowosc(PracHistoria ph) {
                CoreModule core = CoreModule.GetInstance(dc);
                string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
                if (miejscowosc.Length == 0)
                    miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
                if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                    OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                    if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
                }                
                return miejscowosc;
            }
                        
            public static void Msg(object obj) {
            }

            public static ReportHeader report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (report != null && !report.Title.Contains(msg))
                    report.Title += "|" + msg;
            }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZaświadczenieOZarobkach" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zaświadczenie o zarobkach|</strong>%TYP%<strong>|<p align=right></strong>%MIEJSCOWOSC%, {0}<strong></p>" runat="server" DataMember0="Context.ActualDate.Actual"></cc1:reportheader>
			<font face="Tahoma" size="2">
			<p>
				Niniejszym zaświadcza się, że<br>
				<ea:datalabel id="Pan" runat="server" Bold="False"></ea:datalabel>
				&nbsp;
				<ea:datalabel id="Pracownik" runat="server"></ea:datalabel>
				<br>
				<ea:datalabel id="Zamieszkały" runat="server" Bold="False" ></ea:datalabel>
				&nbsp;
				<ea:datalabel id="Adres" runat="server"></ea:datalabel>
				<br>
				PESEL:&nbsp;
				<ea:datalabel id="Pesel" runat="server"></ea:datalabel>
				<br>
				<ea:DataLabel id="Info" runat="server" Bold="False"></ea:DataLabel>
			</p>
			<ea:pagebreak id="PageBreak1" runat="server" Required="False"></ea:pagebreak>
			<p>
				Za okres od
				<ea:datalabel id="OkresOd" runat="server"></ea:datalabel>&nbsp;do
				<ea:datalabel id="OkresDo" runat="server"></ea:datalabel>
				<ea:datalabel id="Otrzymał" runat="server" Bold="False"></ea:datalabel>&nbsp;wynagrodzenie 
				w wysokości:
			</p>
            <ea:datalabel id="Miesiące1" runat="server" Bold="False"></ea:datalabel>
			<ea:pagebreak id="PageBreak5" runat="server" Required="True"></ea:pagebreak>
            <ea:datalabel id="Miesiące2" runat="server" Bold="False"></ea:datalabel>
            <ea:Section runat="server" ID="scBrutto">
			    <P>
				    <TABLE id="Table6" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					    <TR>
						    <TD width="81%" style="height: 16px">Razem brutto:</TD>
						    <TD style="height: 16px">
							    <P align="right">
								    <ea:datalabel id="dlBrutto" runat="server" Format="{0:n}"></ea:datalabel>
							    </P>
						    </TD>
					    </TR>
                        <TR>
                            <TD>
				                słownie: <ea:datalabel id="SłownieBrutto" runat="server" ></ea:datalabel>
                            </TD>
					    </TR>
					    <TR>
						    <TD>Przeciętnie brutto:</TD>
						    <TD>
							    <P align="right">
								    <ea:datalabel id="dlAvrBrutto" runat="server" Format="{0:n}"></ea:datalabel>
							    </P>
						    </TD>
					    </TR>
                        <TR>
                            <TD>
                                słownie: <ea:datalabel id="SłownieAvrBrutto" runat="server" ></ea:datalabel>
                            </TD>
					    </TR>
				    </TABLE>
			    </P>
            </ea:Section>
            <ea:Section runat="server" ID="scNetto">
			    <P>
				    <TABLE id="Table7" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					    <TR>
						    <TD width="81%" style="height: 16px">Razem netto:</TD>
						    <TD style="height: 16px">
							    <P align="right">
								    <ea:datalabel id="dlNetto" runat="server" Format="{0:n}"></ea:datalabel>
							    </P>
						    </TD>
					    </TR>
                        <TR>
                            <TD>
                                słownie: <ea:datalabel id="SłownieNetto" runat="server" ></ea:datalabel>
                            </TD>
					    </TR>
					    <TR>
						    <TD>Przeciętnie netto:</TD>
						    <TD>
							    <P align="right">
								    <ea:datalabel id="dlAvrNetto" runat="server" Format="{0:n}"></ea:datalabel>
							    </P>
						    </TD>
					    </TR>
                        <TR>
                            <TD>
                                słownie: <ea:datalabel id="SłownieAvrNetto" runat="server" ></ea:datalabel>
                            </TD>
					    </TR>
				    </TABLE>
			    </P>
            </ea:Section>
			<P>			
                <ea:Section ID="sectDodatkiNetto" runat="server">
                    <TABLE id="Table3" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					<TR>
						<TD width="81%" style="height: 16px">Inne dodatki nieopodatkowane:
						</TD>
						<TD style="height: 16px">
							<P align="right">
								<ea:datalabel id="NettoPlus" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					</TABLE>
                </ea:Section>			
			</P>
			<ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>			
            <P>Składki na ubezpieczenia&nbsp;społeczne wyniosły:</P>
            <P>
				<TABLE id="Table1" bordercolor="silver" cellSpacing="0" cellPadding="0" width="100%" border="1" style="BORDER-COLLAPSE: collapse; font-size: 1.8ex; font-family: Tahoma;">
					<TR>
						<TD width="20%" style="height: 19px">&nbsp;</TD>
						<TD width="16%" style="height: 19px">
							<P align="center">
                                <em>Emerytalne</em></P>
						</TD>
						<TD width="16%" style="height: 19px">
							<P align="center">
                                <em>Rentowe</em></P>
						</TD>
						<TD width="16%" style="height: 19px">
							<P align="center">
                                <em>Chorobowe</em></P>
						</TD>
						<TD width="16%" style="height: 19px">
							<P align="center">
                                <em>Wypadkowe</em></P>
						</TD>
						<TD width="16%" style="height: 19px">
							<P align="center">
                                <em>Razem</em></P>
						</TD>
					</TR>
					<TR>
						<TD style="height: 5ex">
							<P align="center">
                                <em>Finansowane przez<BR>
								ubezpieczonego</em></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="EmerPrac" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex;">
							<P align="right">
								<ea:datalabel id="RentPrac" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex;">
							<P align="right">
								<ea:datalabel id="ChorPrac" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="WypadPrac" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="PracRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD style="height: 5ex">
							<P align="center">
                                <em>Finansowane przez<BR>
								płatnika</em></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="EmerFirma" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="RentFirma" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="ChorFirma" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="WypadFirma" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="FirmaRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD style="height: 5ex">
							<P align="center">
                                <em>Razem</em></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="EmerRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="RentRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="ChorRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="WypadRazem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
						<TD style="height: 5ex">
							<P align="right">
								<ea:datalabel id="Razem" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>
			<P>
				<TABLE id="Table2" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					<TR>
						<TD width="81%" style="height: 16px">Składka na ubezpieczenie zdrowotne:
						</TD>
						<TD style="height: 16px">
							<P align="right">
								<ea:datalabel id="Zdrow" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Składka na FP, FGŚP i FEP:
						</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="Fundusze" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Koszty uzyskania przychodu:
						</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="Koszty" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Ulga podatkowa:
						</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="Ulga" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Zaliczka podatku:</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="ZalPIT" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Wynagrodzenie pomniejszone o składki ZUS ubezpieczonego:
						</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="BezZus" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
					<TR>
						<TD>Wynagrodzenie pomniejszone o składki ZUS ubezpieczonego,<BR>
							składkę na ubezpieczenie zdrowotne oraz zaliczkę podatku:
						</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="Netto" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
				</TABLE>
            </P>
            <ea:Section ID="sectPotrąceniaNetto" runat="server">
                <P>
                    <TABLE id="Table5" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					    <TR>
						    <TD width="81%" style="height: 16px">Inne potrącenia:
						    </TD>
						    <TD style="height: 16px">
							    <P align="right">
								    <ea:datalabel id="NettoMinus" runat="server" Format="{0:n}"></ea:datalabel></P>
						    </TD>
					    </TR>
					    <TR>
						    <TD>Wynagrodzenie pomniejszone o składki ZUS ubezpieczonego,<BR>
                                składkę na ubezpieczenie zdrowotne, zaliczkę podatku oraz inne potrącenia:
						    </TD>
						    <TD>
							    <P align="right">
								    <ea:datalabel id="NettoPoNettoMinus" runat="server" Format="{0:n}"></ea:datalabel></P>
						    </TD>
					    </TR>
				    </TABLE>
                </P>                        
            </ea:Section>			
            <P>
				<TABLE id="Table4" width="84%" style="font-size: 1.8ex; font-family: Tahoma;">
					<TR>
						<TD>Wypłacone zasiłki rodzinne i pielęgnacyjne:</TD>
						<TD>
							<P align="right">
								<ea:datalabel id="Zasiłki" runat="server" Format="{0:n}"></ea:datalabel></P>
						</TD>
					</TR>
				</TABLE>
			</P>
			<P>Zaświadczenie wydaje się na prośbę zainteresowanego.</P>
			</font>
			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False">
				<SUBTITLES>
					<cc1:FooterSubtitle Width="33" Caption="Pieczęć zakładu pracy<br>&amp;nbsp;"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Width="33" Caption="Pieczęć imienna i podpis głównego księgowego lub osoby przez niego upoważnionej"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Width="33" Caption="Pieczęć imienna i podpis kierownika zakładu lub osoby przez niego upoważnionej"></cc1:FooterSubtitle>
				</SUBTITLES>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>

